<?php

global $wpdb;

/** @var  \Herbert\Framework\Application $container */
/** @var  \Herbert\Framework\Http $http */
/** @var  \Herbert\Framework\Router $router */
/** @var  \Herbert\Framework\Enqueue $enqueue */
/** @var  \Herbert\Framework\Panel $panel */
/** @var  \Herbert\Framework\Shortcode $shortcode */
/** @var  \Herbert\Framework\Widget $widget */

use Illuminate\Database\Capsule\Manager as Capsule;

// Setup the database schema
Capsule::schema()->create('connections', function ($table) {
    $table->increments('id');
    $table->uuid('uid')->default(uniqid());
    $table->text('name')->nullable();
    $table->text('endpoint')->nullable();
    $table->text('api_key')->nullable();
    $table->text('settings')->nullable();
    $table->timestamps();
});

Capsule::schema()->create('jobs', function ($table) {
    $table->increments('id');
    $table->uuid('uid')->default(uniqid());
    $table->text('operation');
    $table->text('user_id');
    $table->text('user_email')->nullable();
    $table->text('user_nicename')->nullable();
    $table->text('status');
    $table->timestamps();
});


Capsule::schema()->create('logs', function ($table) {
    $table->increments('id');
    $table->uuid('uid')->default(uniqid());
    $table->text('operation');
    $table->text('user_id');
    $table->text('user_email');
    $table->text('user_nicename');
    $table->text('status');
    $table->text('description');
    $table->timestamps();
});

Capsule::schema()->create('existing_users', function ($table) {
    $table->increments('id');
    $table->uuid('uid')->default(uniqid());
    $table->text('status')->nullable();
    $table->timestamps();
});

$dropTriggers = [
    'DROP TRIGGER IF EXISTS sendcrux_after_users_update',
    'DROP TRIGGER IF EXISTS sendcrux_after_users_insert',
    'DROP TRIGGER IF EXISTS sendcrux_after_users_delete',
    'DROP TRIGGER IF EXISTS sendcrux_after_usermeta_update',
    'DROP TRIGGER IF EXISTS sendcrux_after_usermeta_insert',
    'DROP TRIGGER IF EXISTS sendcrux_after_usermeta_delete'
];

foreach ($dropTriggers as $sql) {
    Capsule::connection()->getPdo()->exec($sql);
}

$createTrigger = [
    "CREATE TRIGGER sendcrux_after_users_update
        AFTER UPDATE ON {$wpdb->prefix}users
        FOR EACH ROW
        BEGIN
          DECLARE count INT DEFAULT 0;
          SET count = (SELECT COUNT(*) FROM {$wpdb->prefix}sendcrux_jobs WHERE user_id = new.id AND status IN ('new', 'failed'));
          IF count = 0 THEN
              INSERT INTO {$wpdb->prefix}sendcrux_jobs(user_id, operation, status, created_at, updated_at) VALUES(new.id, 'update', 'new');
          END IF;
        END;",
    "CREATE TRIGGER sendcrux_after_users_insert
        AFTER INSERT ON {$wpdb->prefix}users
        FOR EACH ROW
        BEGIN
          DECLARE count INT DEFAULT 0;
          SET count = (SELECT COUNT(*) FROM {$wpdb->prefix}sendcrux_jobs WHERE user_id = new.id AND status IN ('new', 'failed'));
          IF count = 0 THEN
              INSERT INTO {$wpdb->prefix}sendcrux_jobs(user_id, operation, status, created_at, updated_at) VALUES(new.id, 'update', 'new', NOW(), NOW());
          END IF;
        END;",
    "CREATE TRIGGER sendcrux_after_users_delete
        AFTER DELETE ON {$wpdb->prefix}users
        FOR EACH ROW
        BEGIN
          DECLARE count INT DEFAULT 0;
          SET count = (SELECT COUNT(*) FROM {$wpdb->prefix}sendcrux_jobs WHERE user_id = old.id AND operation = 'delete');
          IF count = 0 THEN
              INSERT INTO {$wpdb->prefix}sendcrux_jobs(user_id, operation, status, created_at, updated_at) VALUES(old.id, 'delete', 'new', NOW(), NOW());
          END IF;
        END;",
    "CREATE TRIGGER sendcrux_after_usermeta_update
        AFTER UPDATE ON {$wpdb->prefix}usermeta
        FOR EACH ROW
        BEGIN
          DECLARE count INT DEFAULT 0;
          SET count = (SELECT COUNT(*) FROM {$wpdb->prefix}sendcrux_jobs WHERE user_id = new.user_id AND status IN ('new', 'failed'));
          IF count = 0 THEN
              INSERT INTO {$wpdb->prefix}sendcrux_jobs(user_id, operation, status, created_at, updated_at) VALUES(new.user_id, 'update', 'new', NOW(), NOW());
          END IF;
        END;",
    "CREATE TRIGGER sendcrux_after_usermeta_insert
        AFTER INSERT ON {$wpdb->prefix}usermeta
        FOR EACH ROW
        BEGIN
          DECLARE count INT DEFAULT 0;
          SET count = (SELECT COUNT(*) FROM {$wpdb->prefix}sendcrux_jobs WHERE user_id = new.user_id AND status IN ('new', 'failed'));
          IF count = 0 THEN
              INSERT INTO {$wpdb->prefix}sendcrux_jobs(user_id, operation, status, created_at, updated_at) VALUES(new.user_id, 'update', 'new', NOW(), NOW());
          END IF;
        END;",
    "CREATE TRIGGER sendcrux_after_usermeta_delete
        AFTER DELETE ON {$wpdb->prefix}usermeta
        FOR EACH ROW
        BEGIN
          DECLARE count INT DEFAULT 0;
          SET count = (SELECT COUNT(*) FROM {$wpdb->prefix}sendcrux_jobs WHERE user_id = old.user_id AND status IN ('new', 'failed'));
          IF count = 0 THEN
              INSERT INTO {$wpdb->prefix}sendcrux_jobs(user_id, operation, status, created_at, updated_at) VALUES(old.user_id, 'update', 'new', NOW(), NOW());
          END IF;
        END;"
];

foreach ($createTrigger as $sql) {
    Capsule::connection()->getPdo()->exec($sql);
}
