<?php

namespace Sendcrux\Controllers;

use GuzzleHttp\Psr7\Request;
use Sendcrux\Models\Connection;
use Sendcrux\Models\Job;
use Sendcrux\Models\Log as SyncLog;
use Sendcrux\Library\WpHelper;
use Sendcrux\Library\LogTable;

use Sendcrux\Models\Existingusers;

class ConnectionController
{
    /**
     * Show the post for the given id.
     */
    public function index($id)
    {
        $connection = Connection::first();
        $existing_users = Existingusers::first();
        $cronjob = WpHelper::cronjob_path();
        if (array_key_exists('edit', $_GET)) {
            return view('@Sendcrux/connection/edit.twig', ['connection' => $connection, 'cronjob' => $cronjob,'existing_users' => $existing_users]);
        } else {
            return view('@Sendcrux/connection/index.twig', ['connection' => $connection, 'cronjob' => $cronjob,'existing_users' => $existing_users]);
        }
    }

    /**
     * Show the post for the given id.
     */
    public function log($id)
    {
        // index content
        $table = new LogTable();
        $table->prepare_items();

        return view('@Sendcrux/connection/log.twig', [
            'paging' => paginate_links(['total' => SyncLog::count(), 'current' => $_GET['page']]),
            'table' => $table,
            'current_page' => $_GET['page'],
        ]);
    }

    public function test()
    {
        global $wpdb;
        /***
        $j = Job::first();
        var_dump($j->getUser());
        $j->sync();
        var_dump(\Sendcrux\Library\WpHelper::cronjob_path());
        **/

        var_dump($wpdb->prefix);
        return 0;
    }
}
